create or replace package body tbicds.PCK_TEMPLATE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   
  /*get parsed template recordset*/ 
  procedure GetParsedTemplate2RS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 pi_vEncounterID     in varchar2,
                                 pi_nTemplateID      in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql          varchar2(4000);
      v_vTemplateText clob;
      rsTags          refCursor;
      rsFnTags        refCursor;
      v_recTags       tbicds.template_item%ROWTYPE;
      v_nPos          number;
      v_nPos2         number;
      v_vItemSQL      long;
      rsTagValue      refCursor;
      --v_vTagValue     varchar2(4000);
      v_vTagValue     clob;
      
      --Function tags
      v_vFnTag        varchar2(1000);
      v_nFnTagCount   number;
      v_nFnTagCtr     number;
      
      --Parameters. For the moment there is a limit of 3 parameters.
      type fnParams is varray(3) of varchar2(10);
      params fnParams := fnParams('', '', '');
   
      i number;
      p number; --parameter index

   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      v_vTemplateText   := '';
      v_nPos            := 0;
      v_nPos2           := 0;
      v_vItemSQL        := '';
      v_vTagValue       := '';
      v_vFnTag          := '';
  
      --get the tagged template text
      v_vSql := 'select template from tbicds.template where template_id = :P0';
      execute immediate v_vSql into v_vTemplateText using pi_nTemplateID;
      
      --open the recordset of all the possible tags
      open rsTags for 'select * from tbicds.template_item where description not like ''%(%)%''';
  
      --loop over items in the template_item table
      --and find and replace tags with values from the db
      LOOP
         v_recTags := null;
         FETCH rsTags INTO v_recTags;
         EXIT WHEN NOT rsTags%found;
         
         if v_recTags.description is not null then
            v_nPos := instr(v_vTemplateText, '[' || v_recTags.description || ']');
            
            if v_nPos != 0 then
               --format the sql to run for this tag
               v_vItemSQL := v_recTags.Item_Sql;
               v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%e~', '''' || pi_vEncounterID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
           
               --run the sql and get the value
               v_vTagValue := '';
               begin
                  open rsTagValue for v_vItemSQL;
                  FETCH rsTagValue INTO v_vTagValue;
                  close rsTagValue;
                
               exception
                  when others then
                     --error but keep processing the other tags
                     po_nStatusCode    := 1;
                     po_vStatusComment := po_vStatusComment || '<br>' || 'PCK_TEMPLATE.GetParsedTemplate2RS(): ' || sqlErrm;
                  
               end;
           
               v_vTemplateText := fnReplaceClob(v_vTemplateText, '[' || v_recTags.description || ']', v_vTagValue);
            end if;
         end if;
      END LOOP;
      CLOSE rsTags;
      
      
      --Function TAGs
      --open the recordset of all function tags
      open rsFnTags for 'select * from tbicds.template_item t where t.description like ''%(%)%''';
  
      --loop over the function tags and find and replace them with values from the db
      LOOP
         v_recTags := null;
         FETCH rsFnTags INTO v_recTags;
         EXIT WHEN NOT rsFnTags%found;
         
         if v_recTags.description is not null then
            v_nFnTagCount := REGEXP_COUNT(v_vTemplateText, replace(v_recTags.description,'()',''), 1, 'c');
--            v_vTemplateText := v_vTemplateText || to_char(v_nFnTagCount);
            for v_nFnTagCtr in 1 .. v_nFnTagCount
            loop
              --search for the function tag by using just the first part, e.g. "[fnName(" instead of "[fnName()]"
              --since they (the providers) could write anything between the parenthesis.
              v_nPos := instr(v_vTemplateText, '[' || replace(v_recTags.description,')',''));
              
              if v_nPos != 0 then
                 --there is one, so get the full fnTag they write, e.g. "[fnName(param1, param2)]"
                 v_nPos2 := instr(v_vTemplateText, ']', v_nPos);
                 v_vFnTag := substr(v_vTemplateText, v_nPos, v_nPos2 - v_nPos + 1); --full tag [fnName(param1, param2)]
                 
                 --Extract parameters from the fnTag (step 1 clear params variables, step 2 set parameter index & get the parameters
                 --clear params variables
                 for i in 1 .. params.count
                 loop
                   params(i) := '';
                 end loop;
                 --parameter index
                 p := 1;
                 --get the parameters
                 for i in instr(v_vFnTag, '(') + 1 .. length(v_vFnTag) - 2 -- Minus 2 to excluded the last two characters ")]" 
                 loop
                   if substr(v_vFnTag, i, 1) = ',' then
                     p := p + 1;
                   else
                     params(p) := params(p) || substr(v_vFnTag, i, 1);
                   end if;
                 end loop;
                 
                 --format the sql to run for this tag
                 v_vItemSQL := v_recTags.Item_Sql;
                 v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%e~', '''' || pi_vEncounterID || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
                 
                 v_vItemSQL := replace(v_vItemSQL, '~%p1~', '''' || trim(params(1)) || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%p2~', '''' || trim(params(2)) || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%p3~', '''' || trim(params(3)) || '''');
             
                 --run the sql and get the value
                 v_vTagValue := '';
                 begin
                    open rsTagValue for v_vItemSQL;
                    FETCH rsTagValue INTO v_vTagValue;
                    close rsTagValue;
                  
                 exception
                    when others then
                       --error but keep processing the other tags
                       po_nStatusCode    := 1;
                       po_vStatusComment := po_vStatusComment || '<br>' || 'PCK_TEMPLATE.GetParsedTemplate2RS(): fnTag(x)' || sqlErrm;
                    
                 end;
             
                 v_vTemplateText := replace(v_vTemplateText, v_vFnTag, v_vTagValue);
              end if;
--                v_vTemplateText := v_vTemplateText || '.';
            end loop;
         end if;
--         v_vTemplateText := v_vTemplateText || ',';
      END LOOP;
      CLOSE rsFnTags;
--      v_vTemplateText := v_vTemplateText || ';';
      --open recordset
      open rs for select v_vTemplateText as template_text from dual;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetParsedTemplate2RS(): ' || sqlErrm;
   end;

   /*
   Get template data tag recordset
   */
   procedure GetTemplateDataTagRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * from tbicds.template_item where active = 1 order by item_group_id';
      open rs for v_vSql;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateDataTagRS(): ' || sqlErrm;
   end;

  /*
  Get template data tag group recordset
  */
  procedure GetTemplateDataTagGroupRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * from tbicds.template_item_group where active = 1 order by group_id ';
      open rs for v_vSql;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateDataTagGroupRS(): ' || sqlErrm;
   end;

  /*
  Get template type recordset
  */
  procedure GetTemplateTypeRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.template_type where active = 1 order by type_id';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateTypeRS(): ' || sqlErrm;
   end;

  /*
  Get template recordset
  */
  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.*, tt.description as template_type '
                || 'from tbicds.template t, tbicds.template_type tt '
                || 'where t.type_id in (select type_id from tbicds.template_type where active = 1) '
                || 'and t.active = 1 '
                || 'and t.type_id = tt.type_id '
                || 'order by t.type_id ';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateRS(): ' || sqlErrm;
   end;

  /*
  Get the templates of TypeID = {1 = Subjective, 2 = Objective, 
  3 = Assessment/Plan, 4 = Outcomes}
  */
  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nTypeID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.* '
                || 'from tbicds.template t '
                || 'where t.type_id = ' || pi_nTypeID || ' '
                || 'and t.active = 1 '
                || 'order by t.description';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateRS(): ' || sqlErrm;
   end;
   
   /*
   Update a template
   */
   procedure UpdateTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nTemplateID      in number,
                           pi_nGroupID         in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template set '
                || 'type_id = :P0, description = :P1, template = :P2 '
                || 'where template_id = :P3';
      execute immediate v_vSql using pi_nGroupID, pi_vTemplateName, pi_vTemplateText, pi_nTemplateID; 
      commit;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplate(): ' || sqlErrm;
   end;

   /*
   Insert a template
   */
   procedure InsertTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nSOAPsectID      in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           pi_nTempGroupID     in number,
                           po_nTemplateID      out number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select tbicds.seqTemplateID.Nextval from dual';
      execute immediate v_vSql into po_nTemplateID;
       
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.template ('
                || 'template_id, type_id, description, template, creator_id, '
                || 'created_date, active, template_group_id) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5, :P6, :P7)';
      execute immediate v_vSql using
         po_nTemplateID, pi_nSOAPsectID, pi_vTemplateName, pi_vTemplateText, pi_nUserID,
         sysdate, 1, pi_nTempGroupID;
      commit;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplate(): ' || sqlErrm;
   end;

   /*
   Discontinue a template
   */
   procedure DiscontinueTemplate(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nTemplateID      in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template set active = 0 where template_id = :P0';
      execute immediate v_vSql using pi_nTemplateID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.DiscontinueTemplate(): ' || sqlErrm;
   end;

   /*Insert Template Group*/
   procedure InsertTemplateGroup(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             --
                             pi_vTemplateGrpName in varchar2,
                             pi_vComments        in varchar2,
                             --
                             po_nTemplateGrpID out number,
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nTemplateGrpID number;
   begin
      v_vSql := 'select tbicds.seqtemplategrpid.Nextval from dual';
      execute immediate v_vSql into v_nTemplateGrpID;
      
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.template_group ('
                || 'template_group_id, group_name, comments, active, created_by, '
                || 'last_updated, last_updated_by) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5, :P6) ';
      execute immediate v_vSql using
         v_nTemplateGrpID,pi_vTemplateGrpName, pi_vComments, 1, pi_nUserID,
         sysdate, pi_nUserID;
      commit;
      
      po_nTemplateGrpID := v_nTemplateGrpID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.InsertTemplateGroup(): ' || sqlErrm;
         po_nTemplateGrpID := -1;
   end;

   /*Update Template Group*/
   procedure UpdateTemplateGroup(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             --
                             pi_nTemplateGrpID   in number,
                             pi_vTemplateGrpName in varchar2,
                             pi_vComments        in varchar2,
                             --
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template_group t set '
                || 'group_name = :P0, '
                || 'comments = :P1, '
                || 'last_updated = sysdate, '
                || 'last_updated_by = :P2 '
                || 'where t.template_group_id = :P3 ';
      execute immediate v_vSql using pi_vTemplateGrpName, pi_vComments, pi_nUserID, pi_nTemplateGrpID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplateGroup(): ' || sqlErrm;
   end;

   /*Discontinue Template Group*/
   procedure DiscontinueTemplateGroup(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  --
                                  pi_nTemplateGrpID in number,
                                  --
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template_group set '
                || 'active = 0, last_updated = sysdate, last_updated_by = :P0 '
                || 'where template_group_id = :P1';
      execute immediate v_vSql using pi_nUserID, pi_nTemplateGrpID;
      commit;
      
      --also discontinue templates associated to the group
      v_vSql := 'update tbicds.template set active = 0 where TEMPLATE_GROUP_ID = :P0';
      execute immediate v_vSql using pi_nTemplateGrpID;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.DiscontinueTemplateGroup(): ' || sqlErrm;
   end;

   /*Get Template Groups recordset*/
   procedure GetTemplateGroupsRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      open rs for
         'select * from tbicds.template_group t where t.active = 1';
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateGroupsRS(): ' || sqlErrm;
   end;

   /*Get Group Templates*/
   procedure GetGroupTemplatesRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             
                             pi_nGroupID in number,
                             
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2,
                             rs                out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.*, tt.description as template_type '
                || 'from tbicds.template t, tbicds.template_type tt '
                || 'where t.type_id in (select type_id from tbicds.template_type where active = 1) '
                || 'and t.active = 1 '
                || 'and t.type_id = tt.type_id '
                || 'and t.template_group_id = :P0 '
                || 'order by t.type_id, t.template_group_id';
      open rs for v_vSql using pi_nGroupID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetGroupTemplatesRS(): ' || sqlErrm;
   end;

   /*Get parsed template text*/
   function fnGetParsedTemplateText(pi_vPatientID    in varchar2,
                                   pi_vKey          in varchar2,
                                   pi_vTemplateText in varchar2) return clob 
   is
      v_vTemplateText clob;
      rsTags     refCursor;
      v_recTags  tbicds.template_item%ROWTYPE;
      v_nPos     number;
      v_vItemSQL long;
      rsTagValue  refCursor;
      v_vTagValue varchar2(4000);
   begin
      v_vTemplateText := '';
      v_nPos          := 0;
      v_vItemSQL      := '';
      v_vTagValue     := '';
      
      --get the tagged template text
      v_vTemplateText := pi_vTemplateText;
      
      --open the recordset of all the possible tags
      open rsTags for 'select * from tbicds.template_item';
      --loop over items in the template_item table
      --and find and replace tags with values from the db
      LOOP
         v_recTags := null;
         FETCH rsTags INTO v_recTags;
         EXIT WHEN NOT rsTags%found;
         
         if v_recTags.description is not null then
            v_nPos := instr(v_vTemplateText, '[' || v_recTags.description || ']');
            
            if v_nPos != 0 then
               --format the sql to run for this tag
               v_vItemSQL := v_recTags.Item_Sql;
               v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
               
               --run the sql and get the value
               v_vTagValue := '';
               begin
                  open rsTagValue for v_vItemSQL;
                  FETCH rsTagValue INTO v_vTagValue;
                  close rsTagValue;
               end;
               
               v_vTemplateText := replace(v_vTemplateText, '[' || v_recTags.description || ']', v_vTagValue);
            end if;
         end if;
      END LOOP;
      CLOSE rsTags;
      
      return v_vTemplateText;
   
   end;
   
   /*replace pieces in a  clob*/
   function fnReplaceClob (pi_source in clob
                          ,pi_search in varchar2
                          ,pi_replace in clob) return clob 
   is
   l_pos pls_integer;
   begin
        l_pos := instr(pi_source, pi_search);
        if l_pos > 0 then
           return substr(pi_source, 1, l_pos-1) || pi_replace || substr(pi_source, l_pos + length(pi_search));
           end if;
        return pi_source;
    end;
end;
/

